/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.debug.breakpoints;

import frc.emul.api.engine.IEngineBreakpoint;
import frc.emul.api.engine.IHitCountBreakpoint;
import frc.emul.debug.breakpoints.AbstractMobileBreakpoint;
import frc.emul.util.Utils;
import frc.emul.vectrex.Vectrex;

public class MemoryBreakpoint
extends AbstractMobileBreakpoint
implements IEngineBreakpoint,
IHitCountBreakpoint {
    public static final String PROP_ACCESS = "access";
    private boolean checkRead;
    private boolean checkWrite;
    private int range;
    private boolean isHit;
    private boolean hitWrite;
    private int hitAddr;

    public MemoryBreakpoint(int n) {
        this(n, 1, true, true);
    }

    public MemoryBreakpoint(int n, int n2) {
        this(n, n2, true, true);
    }

    public MemoryBreakpoint(int n, int n2, boolean bl, boolean bl2) {
        super(n);
        this.setMonitoredAccess(bl, bl2);
        this.setRange(n2);
    }

    public int getRange() {
        return this.range;
    }

    public String getDisplayString() {
        StringBuffer stringBuffer = new StringBuffer(60);
        if (this.checkRead) {
            if (this.checkWrite) {
                stringBuffer.append("Read/Write");
            } else {
                stringBuffer.append("Read");
            }
        } else if (this.checkWrite) {
            stringBuffer.append("Write");
        }
        switch (this.range) {
            case 1: {
                stringBuffer.append(" BYTE at $");
                Utils.HEX(4, this.getAddress(), stringBuffer);
                break;
            }
            case 2: {
                stringBuffer.append(" WORD at $");
                Utils.HEX(4, this.getAddress(), stringBuffer);
                break;
            }
            default: {
                Utils.HEX(4, this.getAddress(), stringBuffer.append(" area [$"));
                Utils.HEX(4, this.getAddress() + this.range - 1, stringBuffer.append("-$")).append("]");
            }
        }
        return this.appendCounterDisplay(stringBuffer);
    }

    public String getHitString() {
        if (this.isHit) {
            return String.valueOf(this.hitWrite ? "Write" : "Read") + " access to $" + Utils.HEX4(this.hitAddr) + " from instruction at $" + Utils.HEX4(this.getHitPC());
        }
        return super.getHitString();
    }

    public void reset(Vectrex vectrex) {
        this.isHit = false;
        this.resetCounter();
    }

    public boolean evaluate(Vectrex vectrex) {
        return this.isHit;
    }

    public boolean isTemporary() {
        return false;
    }

    public void setRange(int n) {
        int n2 = this.range;
        this.range = n;
        if (this.getPropSupport() != null) {
            this.getPropSupport().firePropertyChange("range", n2, n);
        }
    }

    public void setMonitoredAccess(boolean bl, boolean bl2) {
        if (bl != this.checkRead || bl2 != this.checkWrite) {
            this.checkRead = bl;
            this.checkWrite = bl2;
            if (this.getPropSupport() != null) {
                this.getPropSupport().firePropertyChange(PROP_ACCESS, null, null);
            }
        }
    }

    public boolean isReadAccessMonitored() {
        return this.checkRead;
    }

    public boolean isWriteAccessMonitored() {
        return this.checkWrite;
    }

    public boolean isHitWriteAccess() {
        return this.hitWrite;
    }

    public int getHitAddress() {
        return this.hitAddr;
    }

    public void check(int n, int n2, boolean bl) {
        this.isHit = false;
        if (this.isEnabled()) {
            boolean bl2;
            if (bl ? !this.checkWrite : !this.checkRead) {
                return;
            }
            int n3 = this.getAddress();
            if (n <= n3) {
                bl2 = n + n2 > n3;
            } else {
                boolean bl3 = bl2 = n < n3 + this.range;
            }
            if (bl2 && this.hitCounter()) {
                this.hitWrite = bl;
                this.hitAddr = n;
                this.isHit = true;
            }
        }
    }
}

